/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package salesApplication;

import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.IntStream;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class TestParallel {
    public static List<String> letters = Arrays.asList("a","b","c","d","e","f","g","h","i","j");
    public static List<Integer> numbers = Arrays.asList(1,2,3,4,5,6,7,8,9,10); 
    public static int count = 0;
    
    //A lambda expression that prints out thread details and takes up time to 
    //illustrate parallel vrs sequential processing
    public static Consumer processStream = s -> {
            System.out.println(LocalTime.now() + " - value: " + s +
                                " - thread: " + Thread.currentThread().getName());
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
    };
    
    //A lambda expression that the elements in a stream by incrementing a global variable 
    //this illustrates the dangers of stateful operations
    public static IntConsumer countStream = i -> {
                            count++;//updating count hence making lambda stateful.
                            try {
                                Thread.sleep(200);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        };
    
    
    public static void main(String[] args) {
        
    }
}
